/*
 * Decompiled with CFR 0.152.
 */
package com.yollo.dmlreforged.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.yollo.dmlreforged.common.items.ItemDeepLearner;
import com.yollo.dmlreforged.core.configs.ClientConfig;
import com.yollo.dmlreforged.core.util.DataModelHelper;
import com.yollo.dmlreforged.core.util.PlayerHelper;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DataOverlay
extends Screen {
    private Minecraft mc = Minecraft.m_91087_();
    private ItemStack deepLearner;
    private NonNullList<ItemStack> dataModels;
    private PlayerHelper playerH;
    private int componentHeight = 26;
    private int barSpacing = 12;
    private static final ResourceLocation experienceBar = new ResourceLocation("dmlreforged", "textures/gui/experience_gui.png");

    public DataOverlay(Component pTitle) {
        super(pTitle);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void renderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.LAYER) {
            return;
        }
        if (!this.mc.m_91302_()) {
            return;
        }
        this.playerH = new PlayerHelper((Player)this.mc.f_91074_);
        if (!this.playerH.isHoldingDeepLearner()) {
            return;
        }
        this.deepLearner = this.playerH.getHeldDeepLearner();
        this.dataModels = DataModelHelper.getValidFromList(ItemDeepLearner.getContainedItems(this.deepLearner));
        int x = (Integer)ClientConfig.guiOverlayHorizontalSpacing.get();
        int y = (Integer)ClientConfig.guiOverlayVerticalSpacing.get();
        int position = (Integer)ClientConfig.guiOverlaySide.get();
        switch (position) {
            case 0: {
                x = x + this.getLeftCornerX() + 18;
                y += 5;
                break;
            }
            case 1: {
                x += this.getRightCornerX();
                y += 5;
                break;
            }
            case 2: {
                x = x + this.getLeftCornerX() + 18;
                y = y + this.getBottomY(this.dataModels.size()) - 5;
                break;
            }
            case 3: {
                x += this.getRightCornerX();
                y = y + this.getBottomY(this.dataModels.size()) - 5;
                break;
            }
            default: {
                x = x + this.getLeftCornerX() + 18;
                y += 5;
            }
        }
        for (int i = 0; i < this.dataModels.size(); ++i) {
            ItemStack stack = (ItemStack)this.dataModels.get(i);
            MutableComponent tierName = DataModelHelper.getTierName(stack, false);
            int tier = DataModelHelper.getTier(stack);
            double k = DataModelHelper.getKillsToNextTier(stack);
            double c = DataModelHelper.getCurrentTierKillCountWithSims(stack);
            int roof = DataModelHelper.getTierRoofAsKills(stack);
            PoseStack pose = event.getMatrixStack();
            this.drawExperienceBar(pose, x, y, i, (Component)tierName, tier, k, c, roof, stack);
        }
    }

    private void drawExperienceBar(PoseStack pose, int x, int y, int index, Component tierName, int tier, double killsToNextTier, double currenKillCount, int tierRoof, ItemStack stack) {
        DecimalFormat f = new DecimalFormat("0.#");
        this.drawItemStack(x - 18, y - 2 + this.barSpacing + index * this.componentHeight, stack);
        DataOverlay.m_93243_((PoseStack)pose, (Font)this.mc.f_91062_, (Component)new TranslatableComponent("dmlreforged.gui.deep_learner.overlay", new Object[]{tierName}), (int)(x - 14), (int)(y + index * this.componentHeight + 2), (int)0xFFFFFF);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)experienceBar);
        this.m_93228_(pose, x, y + this.barSpacing + index * this.componentHeight, 0, 0, 89, 12);
        if (tier == 4) {
            this.m_93228_(pose, x + 1, y + 1 + this.barSpacing + index * this.componentHeight, 0, 12, 89, 11);
        } else {
            this.m_93228_(pose, x + 1, y + 1 + this.barSpacing + index * this.componentHeight, 0, 12, (int)((float)currenKillCount / (float)tierRoof * 89.0f), 11);
            DataOverlay.m_93236_((PoseStack)pose, (Font)this.mc.f_91062_, (String)(f.format(killsToNextTier) + " to go"), (int)(x + 3), (int)(y + 2 + this.barSpacing + index * this.componentHeight), (int)0xFFFFFF);
        }
    }

    private void drawItemStack(int x, int y, ItemStack stack) {
        this.mc.m_91291_().m_115218_(stack, x, y);
    }

    private int getLeftCornerX() {
        return 5;
    }

    private int getRightCornerX() {
        return Minecraft.m_91087_().m_91268_().m_85445_() - this.f_96543_ - 5;
    }

    private int getBottomY(int numberOfBars) {
        return Minecraft.m_91087_().m_91268_().m_85446_() - numberOfBars * this.componentHeight;
    }
}

